/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt.transport;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class TransportedItemStack
implements Comparable<TransportedItemStack> {
    public static final Codec<TransportedItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_49266.fieldOf("Item").forGetter(i -> i.stack), (App)Codec.FLOAT.fieldOf("Pos").forGetter(i -> Float.valueOf(i.beltPosition)), (App)Codec.FLOAT.fieldOf("PrevPos").forGetter(i -> Float.valueOf(i.prevBeltPosition)), (App)Codec.FLOAT.fieldOf("Offset").forGetter(i -> Float.valueOf(i.sideOffset)), (App)Codec.FLOAT.fieldOf("PrevOffset").forGetter(i -> Float.valueOf(i.prevSideOffset)), (App)Codec.INT.fieldOf("InSegment").forGetter(i -> i.insertedAt), (App)Codec.INT.fieldOf("Angle").forGetter(i -> i.angle), (App)class_2350.field_29502.fieldOf("InDirection").forGetter(i -> i.insertedFrom), (App)CreateRegistries.FAN_PROCESSING_TYPE.method_39673().optionalFieldOf("FanProcessingType").forGetter(i -> Optional.ofNullable(i.processedBy)), (App)Codec.INT.optionalFieldOf("FanProcessingTime", (Object)0).forGetter(i -> i.processingTime), (App)Codec.BOOL.optionalFieldOf("Locked", (Object)false).forGetter(i -> i.locked), (App)Codec.BOOL.optionalFieldOf("LockedExternally", (Object)false).forGetter(i -> i.lockedExternally)).apply((Applicative)instance, TransportedItemStack::new));
    private static final Random R = new Random();
    public class_1799 stack;
    public float beltPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public class_2350 insertedFrom;
    public boolean locked;
    public boolean lockedExternally;
    public float prevBeltPosition;
    public float prevSideOffset;
    public FanProcessingType processedBy;
    public int processingTime;

    public TransportedItemStack(class_1799 stack) {
        boolean centered;
        this.stack = stack;
        this.angle = PackageItem.isPackage(stack) ? R.nextInt(4) * 90 + R.nextInt(20) - 10 : ((centered = BeltHelper.isItemUpright(stack)) ? 180 : R.nextInt(360));
        this.sideOffset = this.prevSideOffset = this.getTargetSideOffset();
        this.insertedFrom = class_2350.field_11036;
    }

    private TransportedItemStack(class_1799 stack, float beltPosition, float prevBeltPosition, float sideOffset, float prevSideOffset, int insertedAt, int angle, class_2350 insertedFrom, Optional<FanProcessingType> processedBy, int processingTime, boolean locked, boolean lockedExternally) {
        this.stack = stack;
        this.beltPosition = beltPosition;
        this.prevBeltPosition = prevBeltPosition;
        this.sideOffset = sideOffset;
        this.prevSideOffset = prevSideOffset;
        this.insertedAt = insertedAt;
        this.angle = angle;
        this.insertedFrom = insertedFrom;
        this.locked = locked;
        this.lockedExternally = lockedExternally;
        this.processedBy = processedBy.orElse(null);
        this.processingTime = processingTime;
    }

    public float getTargetSideOffset() {
        return (float)(this.angle - 180) / 1080.0f;
    }

    @Override
    public int compareTo(TransportedItemStack o) {
        return this.beltPosition < o.beltPosition ? 1 : (this.beltPosition > o.beltPosition ? -1 : 0);
    }

    public TransportedItemStack getSimilar() {
        TransportedItemStack copy = new TransportedItemStack(this.stack.method_7972());
        copy.beltPosition = this.beltPosition;
        copy.insertedAt = this.insertedAt;
        copy.insertedFrom = this.insertedFrom;
        copy.prevBeltPosition = this.prevBeltPosition;
        copy.prevSideOffset = this.prevSideOffset;
        copy.processedBy = this.processedBy;
        copy.processingTime = this.processingTime;
        return copy;
    }

    public TransportedItemStack copy() {
        TransportedItemStack copy = this.getSimilar();
        copy.angle = this.angle;
        copy.sideOffset = this.sideOffset;
        return copy;
    }

    public class_2487 serializeNBT(class_7225.class_7874 registries) {
        class_2487 nbt = new class_2487();
        if (!this.stack.method_7960()) {
            nbt.method_67494("Item", class_1799.field_24671, (Object)this.stack);
        }
        nbt.method_10548("Pos", this.beltPosition);
        nbt.method_10548("PrevPos", this.prevBeltPosition);
        nbt.method_10548("Offset", this.sideOffset);
        nbt.method_10548("PrevOffset", this.prevSideOffset);
        nbt.method_10569("InSegment", this.insertedAt);
        nbt.method_10569("Angle", this.angle);
        nbt.method_10569("InDirection", this.insertedFrom.method_10146());
        if (this.processedBy != null) {
            class_2960 key = CreateRegistries.FAN_PROCESSING_TYPE.method_10221((Object)this.processedBy);
            if (key == null) {
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(this.processedBy) + "!");
            }
            nbt.method_10582("FanProcessingType", key.toString());
            nbt.method_10569("FanProcessingTime", this.processingTime);
        }
        if (this.locked) {
            nbt.method_10556("Locked", this.locked);
        }
        if (this.lockedExternally) {
            nbt.method_10556("LockedExternally", this.lockedExternally);
        }
        return nbt;
    }

    public static TransportedItemStack read(class_2487 nbt, class_7225.class_7874 registries) {
        class_1799 source = nbt.method_67491("Item", class_1799.field_24671).orElse(class_1799.field_8037);
        TransportedItemStack stack = new TransportedItemStack(source);
        stack.beltPosition = nbt.method_66563("Pos", 0.0f);
        stack.prevBeltPosition = nbt.method_66563("PrevPos", 0.0f);
        stack.sideOffset = nbt.method_66563("Offset", 0.0f);
        stack.prevSideOffset = nbt.method_66563("PrevOffset", 0.0f);
        stack.insertedAt = nbt.method_68083("InSegment", 0);
        stack.angle = nbt.method_68083("Angle", 0);
        stack.insertedFrom = class_2350.method_10143((int)nbt.method_68083("InDirection", 0));
        stack.locked = nbt.method_68566("Locked", false);
        stack.lockedExternally = nbt.method_68566("LockedExternally", false);
        if (nbt.method_10545("FanProcessingType")) {
            stack.processedBy = FanProcessingType.parse(nbt.method_68564("FanProcessingType", ""));
            stack.processingTime = nbt.method_68083("FanProcessingTime", 0);
        }
        return stack;
    }

    public void clearFanProcessingData() {
        this.processedBy = null;
        this.processingTime = 0;
    }
}

